defmodule Reseau.Application do
  # See https://hexdocs.pm/elixir/Application.html
  # for more information on OTP Applications
  @moduledoc false

  use Application

  @impl true
  def start(_type, _args) do
    topologies = Application.get_env(:libcluster, :topologies)

    children = [
      {Cluster.Supervisor, [topologies, [name: Carte.ClusterSupervisor]]},
      %{id: :pg, start: {:pg, :start_link, []}},
      {Task.Supervisor, name: Reseau.MessengerSupervisor},
      {DynamicSupervisor, strategy: :one_for_one, name: Reseau.ClientSupervisor},
      {Reseau.Serveur, port: Application.get_env(:reseau, :port)}
    ]

    # See https://hexdocs.pm/elixir/Supervisor.html
    # for other strategies and supported options
    opts = [strategy: :one_for_one, name: Reseau.Supervisor]
    Supervisor.start_link(children, opts)
  end
end
